/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.future.pricedepth;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvLegend;
import ilog.views.chart.IlvScaleAnnotation;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.data.IlvDefaultDataSource;
import ilog.views.chart.event.ChartInteractionEvent;
import ilog.views.chart.event.ChartInteractionListener;
import ilog.views.chart.graphic.IlvDataLabelAnnotation;
import ilog.views.chart.interactor.IlvChartInfoViewInteractor;
import ilog.views.chart.interactor.IlvChartPanInteractor;
import ilog.views.chart.renderer.IlvBarChartRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;
import leaseLineQuote.candle.graph.RENDERER;
import leaseLineQuote.candle.graph.custdecoration.Stripes;
import leaseLineQuote.future.pricedepth.ChartControlUtil;
import leaseLineQuote.future.pricedepth.ChartSettingDialog;
import leaseLineQuote.future.pricedepth.PriceDepthHistogram;
import leaseLineQuote.future.pricedepth.PriceDepthHistogramListener;
import leaseLineQuote.future.pricedepth.data.DataSet;
import leaseLineQuote.future.pricedepth.data.SeriesTranslator;
import leaseLineQuote.future.pricedepth.data.SumDataSet;
import leaseLineQuote.future.pricedepth.interactor.DoubleClickDataPickInteractor;
import omnet.object.client.Odepth;
import omnet.object.client.Pdepthchart;

public class PriceDepthChartPanel
extends JPanel
implements PriceDepthHistogram {
    private SeriesTranslator st = new SeriesTranslator();
    public static final String SETTING_BGCOLOR = "SETTING_BGCOLOR";
    public static final String SETTING_BGCOLOR2 = "SETTING_BGCOLOR2";
    public static final String SETTING_BGCOLOR3 = "SETTING_BGCOLOR3";
    public static final String SETTING_GRIDCOLOR = "SETTING_GRIDCOLOR";
    public static final String SETTING_LABELCOLOR = "SETTING_LABELCOLOR";
    public static final String SETTING_BIDBARCOLOR = "SETTING_BA_BIDBARCOLOR";
    public static final String SETTING_ASKBARCOLOR = "SETTING_BA_ASKBARCOLOR";
    public static final String SETTING_HIGHLIGHTCOLOR = "SETTING_HIGHLIGHTCOLOR";
    private static final Map<String, Color> defaultColorSetting;
    private Color BGColor;
    private Color BGColor2;
    private Color BGColor3;
    private Color GirdColor;
    private Color LabelColor;
    private Color BidBarColor;
    private Color AskBarColor;
    private Color HighLightColor;
    public static final int LANG_TCHI = 0;
    public static final int LANG_ENG = 1;
    private int currentLang;
    private Item[] itemList;
    private IlvChart chart;
    private IlvBarChartRenderer barChart;
    private IlvLegend legend;
    private ControlableDataLabelAnnotation dla;
    private DataSet bidDS;
    private DataSet askDS;
    private SumDataSet cBidDS;
    private SumDataSet cAskDS;
    private boolean haveData;
    private String lastId;
    private PriceDepthHistogramListener pdhl;
    private Stripes BG;
    private IlvScaleAnnotation bidAi;
    private IlvScaleAnnotation askAi;
    private IlvScaleAnnotation bidAOAi;
    private IlvScaleAnnotation askAOAi;
    private DoubleClickDataPickInteractor ti;
    public static final char ODEPTH_SIDE_BID = 'B';
    public static final char ODEPTH_SIDE_ASK = 'A';
    private NumberFormat nf;
    private JButton CenterButton;
    private JButton FullViewButton;
    private JButton GraphSettingButton;
    private JComboBox GroupList;
    private JComboBox ProductInfo;
    private JLabel ProductLabel;
    private JButton SubmitButton;
    private JSlider ZoomSlider;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollBar moveScrollBar;
    private JPanel topPanel;

    public static Map<String, Color> getDefaultColorSetting() {
        return Collections.unmodifiableMap(defaultColorSetting);
    }

    @Override
    public Object getSetting() {
        TreeMap<String, Color> setting = new TreeMap<String, Color>();
        setting.put(SETTING_BGCOLOR, this.BGColor);
        setting.put(SETTING_BGCOLOR2, this.BGColor2);
        setting.put(SETTING_BGCOLOR3, this.BGColor3);
        setting.put(SETTING_GRIDCOLOR, this.GirdColor);
        setting.put(SETTING_LABELCOLOR, this.LabelColor);
        setting.put(SETTING_BIDBARCOLOR, this.BidBarColor);
        setting.put(SETTING_ASKBARCOLOR, this.AskBarColor);
        setting.put(SETTING_HIGHLIGHTCOLOR, this.HighLightColor);
        return setting;
    }

    @Override
    public void setSetting(Object objSetting) {
        if (objSetting != null && objSetting instanceof Map) {
            Map setting = (Map)objSetting;
            Object val = setting.get(SETTING_BGCOLOR);
            if (val != null && val instanceof Color) {
                this.BGColor = (Color)val;
            }
            if ((val = setting.get(SETTING_BGCOLOR2)) != null && val instanceof Color) {
                this.BGColor2 = (Color)val;
            }
            if ((val = setting.get(SETTING_BGCOLOR3)) != null && val instanceof Color) {
                this.BGColor3 = (Color)val;
            }
            if ((val = setting.get(SETTING_GRIDCOLOR)) != null && val instanceof Color) {
                this.GirdColor = (Color)val;
            }
            if ((val = setting.get(SETTING_LABELCOLOR)) != null && val instanceof Color) {
                this.LabelColor = (Color)val;
            }
            if ((val = setting.get(SETTING_BIDBARCOLOR)) != null && val instanceof Color) {
                this.BidBarColor = (Color)val;
            }
            if ((val = setting.get(SETTING_ASKBARCOLOR)) != null && val instanceof Color) {
                this.AskBarColor = (Color)val;
            }
            if ((val = setting.get(SETTING_HIGHLIGHTCOLOR)) != null && val instanceof Color) {
                this.HighLightColor = (Color)val;
            }
            this.updateColor();
        }
    }

    @Override
    public void setChinese() {
        this.setLanguage(0);
    }

    @Override
    public void setEnglish() {
        this.setLanguage(1);
    }

    public void setLanguage(final int langId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.currentLang = langId;
            if (langId == 1) {
                this.SubmitButton.setText("Submit");
                this.bidDS.setName("Bid");
                this.askDS.setName("Ask");
                this.ProductLabel.setText("Product :");
                this.GraphSettingButton.setText("Graph Setting");
                this.CenterButton.setText("Center");
                this.FullViewButton.setText("Full View");
                this.st.setEnglish();
            } else {
                this.SubmitButton.setText("\u78ba\u5b9a");
                this.bidDS.setName("\u8cb7\u5165");
                this.askDS.setName("\u8ce3\u51fa");
                this.ProductLabel.setText("\u7522\u54c1 :");
                this.GraphSettingButton.setText("\u5716\u8868\u8a2d\u5b9a");
                this.CenterButton.setText("\u7f5d\u4e2d");
                this.FullViewButton.setText("\u5168\u8996");
                this.st.setChinese();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PriceDepthChartPanel.this.setLanguage(langId);
                }
            });
        }
    }

    @Override
    public void setItemList(String[] itemList) {
        this._setItemList(itemList);
    }

    private void _setItemList(String[] itemList) {
        if (itemList != null) {
            ArrayList<Item> al = new ArrayList<Item>();
            for (String s2 : itemList) {
                al.add(new Item(s2));
            }
            this.itemList = al.toArray(new Item[0]);
        } else {
            this.itemList = new Item[0];
        }
        this.ProductInfo.setModel(new DefaultComboBoxModel<Item>(this.itemList));
    }

    private void clearData() {
        this.haveData = false;
        this.lastId = null;
        this.bidDS.clear();
        this.askDS.clear();
    }

    @Override
    public void setPriceDepthHistogramListener(PriceDepthHistogramListener pdhl) {
        this.pdhl = pdhl;
    }

    private void updateColor() {
        this.chart.getChartArea().setPlotBackground(this.BGColor);
        this.BG.setFillPaint(this.BGColor2);
        this.chart.setBackground(this.BGColor3);
        this.setBackground(this.BGColor3);
        this.chart.getXGrid().setMajorPaint(this.GirdColor);
        this.chart.getXGrid().setDrawOrder(-2);
        for (int i2 = this.chart.getYAxisCount() - 1; i2 >= 0; --i2) {
            this.chart.getYGrid(i2).setMajorPaint(this.GirdColor);
            this.chart.getYGrid(i2).setDrawOrder(-2);
        }
        IlvStyle style = new IlvStyle(this.BidBarColor.darker(), (Paint)this.BidBarColor);
        this.barChart.getBar(this.cBidDS).setStyle(style);
        style = new IlvStyle(this.AskBarColor.darker(), (Paint)this.AskBarColor);
        this.barChart.getBar(this.cAskDS).setStyle(style);
        this.bidAi.getLabelRenderer().setColor(this.BidBarColor);
        this.askAi.getLabelRenderer().setColor(this.AskBarColor);
        this.bidAOAi.getLabelRenderer().setColor(this.BidBarColor);
        this.askAOAi.getLabelRenderer().setColor(this.AskBarColor);
        style = new IlvStyle(this.HighLightColor.darker(), (Paint)this.HighLightColor);
        this.ti.getIlvDataIndicator().setStyle(style);
        this.chart.getXScale().setLabelColor(this.LabelColor);
        for (int i3 = this.chart.getYAxisCount() - 1; i3 >= 0; --i3) {
            this.chart.getYScale(i3).setLabelColor(this.LabelColor);
        }
        this.dla.getLabelRenderer().setColor(this.LabelColor);
    }

    public PriceDepthChartPanel() {
        this(new String[]{"HSIM9", "HSIN9"});
    }

    public PriceDepthChartPanel(String[] itemList) {
        this.st.setChinese();
        this.BGColor = defaultColorSetting.get(SETTING_BGCOLOR);
        this.BGColor2 = defaultColorSetting.get(SETTING_BGCOLOR2);
        this.BGColor3 = defaultColorSetting.get(SETTING_BGCOLOR3);
        this.GirdColor = defaultColorSetting.get(SETTING_GRIDCOLOR);
        this.LabelColor = defaultColorSetting.get(SETTING_LABELCOLOR);
        this.BidBarColor = defaultColorSetting.get(SETTING_BIDBARCOLOR);
        this.AskBarColor = defaultColorSetting.get(SETTING_ASKBARCOLOR);
        this.HighLightColor = defaultColorSetting.get(SETTING_HIGHLIGHTCOLOR);
        this.currentLang = 0;
        this.chart = new IlvChart();
        this.barChart = new IlvBarChartRenderer();
        this.legend = new IlvLegend();
        this.dla = new ControlableDataLabelAnnotation();
        this.bidDS = new DataSet("Bid", new double[0], new double[0], true);
        this.askDS = new DataSet("Ask", new double[0], new double[0], true);
        this.cBidDS = new SumDataSet(this.bidDS, 1);
        this.cAskDS = new SumDataSet(this.askDS, 1);
        this.haveData = false;
        this.lastId = null;
        this.pdhl = null;
        this.BG = new Stripes(this.chart.getYScale(0), this.BGColor2);
        this.bidAi = new IlvScaleAnnotation(0.0);
        this.askAi = new IlvScaleAnnotation(0.0);
        this.bidAOAi = new IlvScaleAnnotation(0.0);
        this.askAOAi = new IlvScaleAnnotation(0.0);
        this.ti = new DoubleClickDataPickInteractor();
        this.nf = NumberFormat.getInstance();
        this.initComponents();
        this.ProductLabel.setVisible(false);
        this.ProductInfo.setVisible(false);
        this.initChart();
        this._setItemList(itemList);
        this.setChinese();
    }

    private void initChart() {
        IlvDefaultDataSource ds = new IlvDefaultDataSource();
        ds.addDataSet(this.cBidDS);
        ds.addDataSet(this.cAskDS);
        this.barChart.setDataSource(ds);
        this.barChart.setOverlap(100.0);
        this.BG.setDrawOrder(-3);
        this.chart.addDecoration(this.BG);
        this.ti.addChartInteractionListener(new ChartInteractionListener(){

            @Override
            public void interactionPerformed(ChartInteractionEvent event) {
                IlvDisplayPoint point = event.getDisplayPoint();
                try {
                    String id = PriceDepthChartPanel.this.lastId;
                    if (id != null) {
                        if (point.dataSet == PriceDepthChartPanel.this.bidDS || point.dataSet == PriceDepthChartPanel.this.cBidDS) {
                            System.out.println("interactionPerformed : B : " + id + ", " + point.getXData() + ", " + point.getYData());
                            if (PriceDepthChartPanel.this.pdhl != null) {
                                PriceDepthChartPanel.this.pdhl.processUserPriceDepthRequest(id, (byte)1, (int)point.getXData());
                            }
                        } else if (point.dataSet == PriceDepthChartPanel.this.askDS || point.dataSet == PriceDepthChartPanel.this.cAskDS) {
                            System.out.println("interactionPerformed : A : " + id + ", " + point.getXData() + ", " + point.getYData());
                            if (PriceDepthChartPanel.this.pdhl != null) {
                                PriceDepthChartPanel.this.pdhl.processUserPriceDepthRequest(id, (byte)2, (int)point.getXData());
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.chart.addInteractor(this.ti);
        this.chart.addDecoration(this.ti.getIlvDataIndicator());
        InfoViewInteractor ivi = new InfoViewInteractor();
        ivi.setPickingMode(1);
        this.chart.addInteractor(ivi);
        this.chart.getChartArea().addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e2) {
                if (e2.getScrollType() == 0) {
                    if (e2.getUnitsToScroll() > 0) {
                        PriceDepthChartPanel.this.ZoomSlider.setValue(PriceDepthChartPanel.this.ZoomSlider.getValue() - PriceDepthChartPanel.this.ZoomSlider.getMajorTickSpacing());
                    } else {
                        PriceDepthChartPanel.this.ZoomSlider.setValue(PriceDepthChartPanel.this.ZoomSlider.getValue() + PriceDepthChartPanel.this.ZoomSlider.getMajorTickSpacing());
                    }
                }
            }
        });
        this.chart.addRenderer(this.barChart);
        this.add((Component)this.chart, "Center");
        this.chart.setXScrollBar(this.moveScrollBar);
        this.chart.addLegend(this.legend, "North_Top");
        this.bidAi.getLabelRenderer().setRotation(45.0);
        this.bidAi.getLabelRenderer().setOpaque(false);
        this.chart.getXScale().addAnnotation(this.bidAi);
        this.bidAOAi.setLabel("A.O.");
        this.chart.getXScale().addAnnotation(this.bidAOAi);
        this.askAi.getLabelRenderer().setRotation(45.0);
        this.askAi.getLabelRenderer().setOpaque(false);
        this.chart.getXScale().addAnnotation(this.askAi);
        this.askAOAi.setLabel("A.O.");
        this.chart.getXScale().addAnnotation(this.askAOAi);
        this.chart.addInteractor(new IlvChartPanInteractor(16));
        this.dla.getLabelRenderer().setBorder(null);
        this.dla.getLabelRenderer().setOpaque(false);
        this.barChart.setDataLabelling(2);
        this.barChart.setDataLabelLayout(2);
        this.barChart.setAnnotation(this.dla);
        this.updateColor();
    }

    @Override
    public void set(final Pdepthchart pc) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._set(pc);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PriceDepthChartPanel.this._set(pc);
                }
            });
        }
    }

    private void _set(Pdepthchart pc) {
        int i2;
        int end;
        Iterator<Object> it;
        TreeMap<Integer, Counter> bid = new TreeMap<Integer, Counter>();
        TreeMap<Integer, Counter> ask = new TreeMap<Integer, Counter>();
        Integer nominal = -1;
        double max = 0.0;
        double min = 0.0;
        for (Object key : pc.orders.keySet()) {
            for (Object od : (Vector)pc.orders.get(key)) {
                Counter c2;
                if (nominal != ((Odepth)od).nominal) {
                    nominal = ((Odepth)od).nominal;
                }
                if (((Odepth)od).side == 'B') {
                    c2 = (Counter)bid.get(((Odepth)od).nominal);
                    if (c2 == null) {
                        c2 = new Counter();
                        bid.put(nominal, c2);
                    }
                    c2.count += ((Odepth)od).qty;
                    max = Math.max(max, (double)((Odepth)od).nominal);
                    continue;
                }
                if (((Odepth)od).side != 'A') continue;
                c2 = (Counter)ask.get(((Odepth)od).nominal);
                if (c2 == null) {
                    c2 = new Counter();
                    ask.put(nominal, c2);
                }
                c2.count += ((Odepth)od).qty;
                if (min <= 0.0) {
                    min = ((Odepth)od).nominal;
                    continue;
                }
                min = Math.min(min, (double)((Odepth)od).nominal);
            }
        }
        Integer li = Integer.MIN_VALUE;
        Counter zeroCounter = new Counter();
        ArrayList<Integer> ml = new ArrayList<Integer>();
        for (Integer i3 : bid.keySet()) {
            if (li != Integer.MIN_VALUE && li != Integer.MAX_VALUE && i3 != Integer.MIN_VALUE && i3 != Integer.MAX_VALUE && Math.abs(li - i3) > 1) {
                for (int ii = li + 1; ii < i3; ++ii) {
                    ml.add(ii);
                }
            }
            li = i3;
        }
        for (Integer i3 : ml) {
            bid.put(i3, zeroCounter);
        }
        int size = bid.size();
        if (size > 0 && size < 10) {
            int start;
            it = bid.keySet().iterator();
            end = start = ((Integer)it.next()).intValue();
            while (it.hasNext()) {
                end = (Integer)it.next();
            }
            for (i2 = 1; i2 <= 10 - size; ++i2) {
                bid.put(start - i2, zeroCounter);
                bid.put(end + i2, zeroCounter);
            }
        }
        li = Integer.MIN_VALUE;
        ml.clear();
        for (Integer i4 : ask.keySet()) {
            if (li != Integer.MIN_VALUE && li != Integer.MAX_VALUE && i4 != Integer.MIN_VALUE && i4 != Integer.MAX_VALUE && Math.abs(li - i4) > 1) {
                for (int ii = li + 1; ii < i4; ++ii) {
                    ml.add(ii);
                }
            }
            li = i4;
        }
        for (Integer i5 : ml) {
            ask.put(i5, zeroCounter);
        }
        size = ask.size();
        if (size > 0 && size < 10) {
            int start;
            it = ask.keySet().iterator();
            end = start = ((Integer)it.next()).intValue();
            while (it.hasNext()) {
                end = (Integer)it.next();
            }
            for (i2 = 1; i2 <= 10 - size; ++i2) {
                ask.put(start - i2, zeroCounter);
                ask.put(end + i2, zeroCounter);
            }
        }
        double[] bidX = new double[bid.size()];
        double[] bidY = new double[bid.size()];
        int index = 0;
        for (Integer k2 : bid.keySet()) {
            bidX[index] = k2.doubleValue();
            bidY[index++] = ((Counter)bid.get((Object)k2)).count;
        }
        if (bid.size() > 0) {
            this.bidDS.setData(bidX, bidY, index);
        } else {
            this.bidDS.clear();
        }
        double[] askX = new double[ask.size()];
        double[] askY = new double[ask.size()];
        index = 0;
        for (Integer k3 : ask.keySet()) {
            askX[index] = k3.doubleValue();
            askY[index++] = ((Counter)ask.get((Object)k3)).count;
        }
        if (ask.size() > 0) {
            this.askDS.setData(askX, askY, index);
        } else {
            this.askDS.clear();
        }
        this.bidAi.setValue(max);
        this.bidAi.setLabel("\n" + this.nf.format(max));
        this.askAi.setValue(min);
        this.askAi.setLabel("\n" + this.nf.format(min));
        if (this.lastId == null || !this.lastId.equals(pc.series_id)) {
            this.fullView();
            this.lastId = pc.series_id;
        }
        double yMax = Math.max(this.bidDS.getYRange().max, this.askDS.getYRange().max);
        for (int i6 = this.chart.getYAxisCount() - 1; i6 >= 0; --i6) {
            this.chart.getYAxis(i6).setDataMax(yMax * 1.05);
        }
        this.haveData = true;
    }

    public void setPeriod(int period) {
        this.cBidDS.setPeriod(period);
        this.cAskDS.setPeriod(period);
        this.legend.repaint();
    }

    private void toCenter() {
        PriceDepthChartPanel.toCenter(this.chart, this.cBidDS, this.cAskDS);
    }

    private static void toCenter(IlvChart chart, IlvDataSet bidDS, IlvDataSet askDS) {
        double bidMax = bidDS.getXRange(null).max;
        double askMin = askDS.getXRange(null).min;
        double mid = (bidMax + askMin) / 2.0;
        ChartControlUtil.scroll2Center(chart, mid);
    }

    private void zoomTo(int value) {
        ChartControlUtil.zoomTo(this.chart, value, this.ZoomSlider.getMinimum(), this.ZoomSlider.getMaximum());
        this.dla.setEnable(value < 20);
        this.toCenter();
    }

    private void fullView() {
        ChartControlUtil.autoScale(this.chart, true);
        this.dla.setEnable(false);
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.ProductLabel = new JLabel();
        this.ProductInfo = new JComboBox();
        this.GroupList = new JComboBox();
        this.SubmitButton = new JButton();
        this.jPanel3 = new JPanel();
        this.GraphSettingButton = new JButton();
        this.FullViewButton = new JButton();
        this.CenterButton = new JButton();
        this.jPanel1 = new JPanel();
        this.moveScrollBar = new JScrollBar();
        this.jPanel4 = new JPanel();
        this.ZoomSlider = new JSlider(new DefaultBoundedRangeModel(50, 0, 10, 100){});
        this.setLayout(new BorderLayout());
        this.topPanel.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new FlowLayout(0));
        this.ProductLabel.setText("\u7522\u54c1 :");
        this.jPanel2.add(this.ProductLabel);
        this.ProductInfo.setModel(new DefaultComboBoxModel<String>(new String[]{"\u5373\u6708\u671f\u6307", "\u4e0b\u6708\u671f\u6307", "\u5b63\u5ea6\u671f\u6307", "\u5373\u6708\u5c0f\u671f", "\u4e0b\u6708\u5c0f\u671f", "\u5b63\u5ea6\u5c0f\u671f"}));
        this.jPanel2.add(this.ProductInfo);
        this.GroupList.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "5", "10", "20"}));
        this.jPanel2.add(this.GroupList);
        this.SubmitButton.setText("\u78ba\u5b9a");
        this.SubmitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PriceDepthChartPanel.this.SubmitButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.SubmitButton);
        this.topPanel.add((Component)this.jPanel2, "West");
        this.jPanel3.setLayout(new FlowLayout(2));
        this.GraphSettingButton.setText("\u5716\u8868\u8a2d\u5b9a");
        this.GraphSettingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PriceDepthChartPanel.this.GraphSettingButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.GraphSettingButton);
        this.FullViewButton.setText("Full View");
        this.FullViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PriceDepthChartPanel.this.FullViewButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.FullViewButton);
        this.CenterButton.setText("\u7f5d\u4e2d");
        this.CenterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PriceDepthChartPanel.this.CenterButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.CenterButton);
        this.topPanel.add((Component)this.jPanel3, "East");
        this.add((Component)this.topPanel, "North");
        this.jPanel1.setLayout(new BorderLayout());
        this.moveScrollBar.setOrientation(0);
        this.moveScrollBar.setPreferredSize(new Dimension(48, 20));
        this.jPanel1.add((Component)this.moveScrollBar, "Center");
        this.add((Component)this.jPanel1, "Last");
        this.jPanel4.setLayout(new BorderLayout());
        this.ZoomSlider.setMajorTickSpacing(10);
        this.ZoomSlider.setMaximum(99);
        this.ZoomSlider.setMinimum(10);
        this.ZoomSlider.setMinorTickSpacing(5);
        this.ZoomSlider.setOrientation(1);
        this.ZoomSlider.setPaintTicks(true);
        this.ZoomSlider.setMaximumSize(new Dimension(40, Short.MAX_VALUE));
        this.ZoomSlider.setMinimumSize(new Dimension(40, 36));
        this.ZoomSlider.setOpaque(false);
        this.ZoomSlider.setPreferredSize(new Dimension(40, 200));
        CustomSliderUI cu = new CustomSliderUI(this.ZoomSlider);
        this.ZoomSlider.setUI(cu);
        this.ZoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PriceDepthChartPanel.this.ZoomSliderStateChanged(evt);
            }
        });
        this.jPanel4.add((Component)this.ZoomSlider, "Center");
        this.add((Component)this.jPanel4, "After");
    }

    private void SubmitButtonActionPerformed(ActionEvent evt) {
        try {
            this.setPeriod(Integer.parseInt(this.GroupList.getSelectedItem().toString()));
            String id = ((Item)this.ProductInfo.getSelectedItem()).getItemId();
            if (!(this.lastId != null && this.lastId.equals(id) || this.pdhl == null)) {
                this.pdhl.requestPriceDepthHistogramData(id);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void GraphSettingButtonActionPerformed(ActionEvent evt) {
        Map<String, Color> result = ChartSettingDialog.showDialog(this, "Color Setting", this.getSetting(), this.currentLang);
        this.setSetting(result);
        this.updateColor();
    }

    private void CenterButtonActionPerformed(ActionEvent evt) {
        this.toCenter();
    }

    private void ZoomSliderStateChanged(ChangeEvent evt) {
        this.zoomTo(this.ZoomSlider.getValue());
    }

    private void FullViewButtonActionPerformed(ActionEvent evt) {
        this.fullView();
    }

    static {
        RENDERER.startupILog();
        defaultColorSetting = new TreeMap<String, Color>();
        System.out.println("PriceDepthChartPanel - 2012-12-19");
        defaultColorSetting.put(SETTING_BGCOLOR, Color.YELLOW);
        defaultColorSetting.put(SETTING_BGCOLOR2, new Color(240, 240, 240));
        defaultColorSetting.put(SETTING_BGCOLOR3, new Color(240, 240, 240));
        defaultColorSetting.put(SETTING_GRIDCOLOR, Color.GREEN);
        defaultColorSetting.put(SETTING_LABELCOLOR, Color.BLACK);
        defaultColorSetting.put(SETTING_BIDBARCOLOR, new Color(1, 160, 255, 200));
        defaultColorSetting.put(SETTING_ASKBARCOLOR, new Color(255, 30, 1, 200));
        defaultColorSetting.put(SETTING_HIGHLIGHTCOLOR, Color.ORANGE);
    }

    class CustomSliderUI
    extends BasicSliderUI {
        public CustomSliderUI(JSlider b2) {
            super(b2);
        }

        @Override
        protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
            return new CustomTrackListener();
        }

        class CustomTrackListener
        extends BasicSliderUI.TrackListener {
            CustomTrackListener() {
                super(CustomSliderUI.this);
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                super.mousePressed(e2);
            }
        }
    }

    public class InfoViewInteractor
    extends IlvChartInfoViewInteractor {
        private NumberFormat numFmt = NumberFormat.getNumberInstance();

        public InfoViewInteractor() {
            this.numFmt.setMaximumFractionDigits(2);
        }

        @Override
        protected Point computePosition(Dimension arg0, int arg1, int arg2) {
            Point p2 = super.computePosition(arg0, arg1, arg2);
            Rectangle r2 = new Rectangle(p2, arg0);
            Rectangle vr = this.getChart().getVisibleRect();
            if (!vr.contains(r2)) {
                int x = p2.x - arg0.width / 2;
                if (x < 0) {
                    x = p2.x + arg0.width / 2;
                }
                p2.x = x;
            }
            return p2;
        }

        @Override
        protected String getInfoText(IlvDisplayPoint point) {
            String name = point.getDataSet().getName();
            String label = point.getDataSet().getDataLabel(point.index);
            String xValue = this.numFmt.format(point.getXData());
            String yValue = this.numFmt.format(point.getYData());
            StringBuilder sb = new StringBuilder(40);
            sb.append("<html>");
            sb.append("<font color='#");
            String color = "";
            color = point.getDataSet() == PriceDepthChartPanel.this.cBidDS ? Integer.toHexString(PriceDepthChartPanel.this.BidBarColor.getRGB()) : Integer.toHexString(PriceDepthChartPanel.this.AskBarColor.getRGB());
            if (color.length() > 6) {
                color = color.substring(2);
            }
            sb.append(color).append("'>");
            sb.append(name);
            if (label != null) {
                sb.append(':').append(label);
            }
            sb.append(" (").append(xValue).append(") - ").append(yValue);
            sb.append("</font>");
            IlvDataSet inDs = point.getDataSet();
            SumDataSet checkDs = null;
            if (inDs == PriceDepthChartPanel.this.cBidDS) {
                checkDs = PriceDepthChartPanel.this.cAskDS;
                color = Integer.toHexString(PriceDepthChartPanel.this.AskBarColor.getRGB());
            } else if (inDs == PriceDepthChartPanel.this.cAskDS) {
                checkDs = PriceDepthChartPanel.this.cBidDS;
                color = Integer.toHexString(PriceDepthChartPanel.this.BidBarColor.getRGB());
            }
            if (color.length() > 6) {
                color = color.substring(2);
            }
            if (checkDs != null) {
                int index = -1;
                for (int i2 = 0; i2 < checkDs.getDataCount(); ++i2) {
                    if (checkDs.getXData(i2) != point.getXData()) continue;
                    index = i2;
                    break;
                }
                if (index != -1 && checkDs.getYData(index) > 0.0) {
                    name = checkDs.getName();
                    label = checkDs.getDataLabel(index);
                    xValue = this.numFmt.format(checkDs.getXData(index));
                    yValue = this.numFmt.format(checkDs.getYData(index));
                    sb.append("<font color='#");
                    sb.append(color).append("'>");
                    sb.append("<br/>").append(name);
                    if (label != null) {
                        sb.append(':').append(label);
                    }
                    sb.append(" (").append(xValue).append(") - ").append(yValue);
                    sb.append("</font>");
                }
            }
            sb.append("</html>");
            return sb.toString();
        }
    }

    private class Counter {
        int count = 0;

        private Counter() {
        }
    }

    class ControlableDataLabelAnnotation
    extends IlvDataLabelAnnotation {
        private boolean enable = false;

        ControlableDataLabelAnnotation() {
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public boolean isEnable() {
            return this.enable;
        }

        @Override
        public void draw(Graphics g2, IlvDisplayPoint dp) {
            int qty;
            if (this.enable && (qty = (int)dp.getYData()) > 0) {
                super.draw(g2, dp);
            }
        }
    }

    class Item {
        private final String itemId;

        private Item(String itemId) {
            this.itemId = itemId;
        }

        public String getItemId() {
            return this.itemId;
        }

        public String toString() {
            PriceDepthChartPanel.this.st.setData(this.itemId);
            return PriceDepthChartPanel.this.st.getMarketName() + " - " + PriceDepthChartPanel.this.st.getDescription();
        }
    }
}

