/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.future.pricedepth.data;

import java.util.HashSet;

public class SeriesTranslator {
    public int mode = 1;
    public static final int MODE_CHI = 0;
    public static final int MODE_ENG = 1;
    private int type = 0;
    private final int TYPE_CALL = 0;
    private final int TYPE_PUT = 1;
    private String market = "";
    private String year = "";
    private String month = "";
    private String name = "";
    private String description = "";
    private String futureOption = "";
    private boolean showStrick = false;
    public String[] activeMkt = new String[]{"MHI", "HSI", "HHI", "MCH"};
    public String[] productList = new String[]{"34-4002-4", "34-4002-22", "34-4002-23", "34-4002-119", "34-4002-120", "34-4002-121", "16-4004-4", "16-4004-22", "16-4004-23", "16-4004-119", "16-4004-120", "16-4004-121", "38-4001-4", "38-4001-22", "38-4001-23", "38-4001-119", "38-4001-120", "38-4001-121", "38-4008-4", "38-4008-119", "38-4008-120", "38-4008-121"};
    public String[] noProductClt = new String[]{"34-4002-119", "34-4002-120", "34-4002-121", "16-4004-119", "16-4004-120", "16-4004-121", "38-4001-119", "38-4001-120", "38-4001-121", "38-4008-119", "38-4008-120", "38-4008-121"};

    public static void main(String[] args) {
        SeriesTranslator st = new SeriesTranslator();
        st.setChinese();
        st.setData("HSI17000V3");
        System.out.println(st.getMarketName() + " - " + st.getDescription());
        st.setData("HSIX5");
        System.out.println(st.getMarketName() + " - " + st.getDescription());
        st.setData("HSIM9");
        System.out.println(st.getMarketName() + " - " + st.getDescription());
    }

    public void setData(String name) {
        this.name = name;
        this.process();
    }

    public void setEnglish() {
        this.mode = 1;
    }

    public void setChinese() {
        this.mode = 0;
    }

    public String getType() {
        String response = "";
        return response;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMarketName() {
        if (this.mode == 0) {
            return this.mapChiFutures(this.market);
        }
        return this.market;
    }

    public void isShowStrick(boolean b2) {
        this.showStrick = b2;
    }

    private void processStrickOption() {
        try {
            this.market = "";
            this.market = this.name.substring(0, 3);
            char cyear = this.name.charAt(this.name.length() - 1);
            char cmon = this.name.charAt(this.name.length() - 2);
            String strick = this.name.substring(3, this.name.length() - 2);
            this.mapOptionMonth(cmon);
            this.description = this.mode == 0 ? (this.type == 0 ? this.mapChiFutures(this.market) + strick + "-" + this.mapChiMonth(this.mapOptionMonth(cmon)) + "-\u8cfc" : this.mapChiFutures(this.market) + strick + "-" + this.mapChiMonth(this.mapOptionMonth(cmon)) + "-\u6cbd") : (this.type == 0 ? this.market + "-" + this.mapOptionMonth(cmon) + "-" + cyear + "-CALL" : this.market + "-" + this.mapOptionMonth(cmon) + "-" + cyear + "-PUT");
        }
        catch (Exception e2) {
            this.description = e2.getMessage();
        }
    }

    private void process() {
        this.description = "";
        this.futureOption = "";
        if (this.name.indexOf(47) != -1) {
            this.processCombo();
        } else if (this.name.length() > 5) {
            if (this.showStrick) {
                this.processStrickOption();
            } else {
                this.processOption();
            }
        } else {
            this.processFuture();
        }
    }

    private void processCombo() {
        try {
            this.market = "";
            this.market = this.name.substring(0, 3);
            char cyear = this.name.charAt(this.name.length() - 1);
            char cmon2 = this.name.charAt(this.name.length() - 2);
            char cmon1 = this.name.charAt(this.name.length() - 5);
            this.description = this.mode == 0 ? this.mapChiFutures(this.market) + "-" + this.mapChiMonth(this.mapFutureMonth(cmon1)) + "/" + this.mapChiMonth(this.mapFutureMonth(cmon2)) : this.market + "-" + this.mapFutureMonth(cmon1) + "/" + this.mapFutureMonth(cmon2) + "-" + cyear + "-Future";
        }
        catch (Exception e2) {
            this.description = e2.getMessage();
        }
    }

    private void processOption() {
        try {
            this.market = "";
            this.market = this.name.substring(0, 3);
            char cyear = this.name.charAt(this.name.length() - 1);
            char cmon = this.name.charAt(this.name.length() - 2);
            this.mapOptionMonth(cmon);
            this.description = this.mode == 0 ? (this.type == 0 ? this.mapChiFutures(this.market) + "-" + this.mapChiMonth(this.mapOptionMonth(cmon)) + "-CALL" : this.mapChiFutures(this.market) + "-" + this.mapChiMonth(this.mapOptionMonth(cmon)) + "-PUT") : (this.type == 0 ? this.market + "-" + this.mapOptionMonth(cmon) + "-" + cyear + "-CALL" : this.market + "-" + this.mapOptionMonth(cmon) + "-" + cyear + "-PUT");
        }
        catch (Exception e2) {
            this.description = e2.getMessage();
        }
    }

    private void processFuture() {
        try {
            this.market = "";
            this.market = this.name.substring(0, 3);
            char cyear = this.name.charAt(this.name.length() - 1);
            char cmon = this.name.charAt(this.name.length() - 2);
            this.description = this.mode == 0 ? this.mapChiFutures(this.market) + "-" + this.mapChiMonth(this.mapFutureMonth(cmon)) : this.market + "-" + this.mapFutureMonth(cmon) + "-" + cyear + "-Future";
        }
        catch (Exception e2) {
            this.description = e2.getMessage();
        }
    }

    private String mapFutureMonth(char id) {
        switch (id) {
            case 'F': {
                return "Jan";
            }
            case 'G': {
                return "Feb";
            }
            case 'H': {
                return "Mar";
            }
            case 'J': {
                return "Apr";
            }
            case 'K': {
                return "May";
            }
            case 'M': {
                return "Jun";
            }
            case 'N': {
                return "Jul";
            }
            case 'Q': {
                return "Aug";
            }
            case 'U': {
                return "Sep";
            }
            case 'V': {
                return "Oct";
            }
            case 'X': {
                return "Nov";
            }
            case 'Z': {
                return "Dec";
            }
        }
        return "";
    }

    private String mapOptionMonth(char id) {
        switch (id) {
            case 'A': {
                this.type = 0;
                return "Jan";
            }
            case 'B': {
                this.type = 0;
                return "Feb";
            }
            case 'C': {
                this.type = 0;
                return "Mar";
            }
            case 'D': {
                this.type = 0;
                return "Apr";
            }
            case 'E': {
                this.type = 0;
                return "May";
            }
            case 'F': {
                this.type = 0;
                return "Jun";
            }
            case 'G': {
                this.type = 0;
                return "Jul";
            }
            case 'H': {
                this.type = 0;
                return "Aug";
            }
            case 'I': {
                this.type = 0;
                return "Sep";
            }
            case 'J': {
                this.type = 0;
                return "Oct";
            }
            case 'K': {
                this.type = 0;
                return "Nov";
            }
            case 'L': {
                this.type = 0;
                return "Dec";
            }
            case 'M': {
                this.type = 1;
                return "Jan";
            }
            case 'N': {
                this.type = 1;
                return "Feb";
            }
            case 'O': {
                this.type = 1;
                return "Mar";
            }
            case 'P': {
                this.type = 1;
                return "Apr";
            }
            case 'Q': {
                this.type = 1;
                return "May";
            }
            case 'R': {
                this.type = 1;
                return "Jun";
            }
            case 'S': {
                this.type = 1;
                return "Jul";
            }
            case 'T': {
                this.type = 1;
                return "Aug";
            }
            case 'U': {
                this.type = 1;
                return "Sep";
            }
            case 'V': {
                this.type = 1;
                return "Oct";
            }
            case 'W': {
                this.type = 1;
                return "Nov";
            }
            case 'X': {
                this.type = 1;
                return "Dec";
            }
        }
        return "";
    }

    private String mapChineseName(String id) {
        String desc = id;
        if (id.equalsIgnoreCase("BEA")) {
            desc = "Bank of East Asia Ltd., The";
        } else if (id.equalsIgnoreCase("BOC")) {
            desc = "BOC Hong Kong (Holding)Ltd.";
        } else if (id.equalsIgnoreCase("CHT")) {
            desc = "China Mobile(Hong Kong) Ltd";
        } else if (id.equalsIgnoreCase("CHU")) {
            desc = "China Unicom Ltd";
        } else if (id.equalsIgnoreCase("CIT")) {
            desc = "Citic Pacific Ltd";
        } else if (id.equalsIgnoreCase("CKH")) {
            desc = "Cheung Kong (Holdings)Ltd";
        } else if (id.equalsIgnoreCase("CKI")) {
            desc = "Cheung Kong Infrastructure Holdings Ltd.";
        } else if (id.equalsIgnoreCase("CLP")) {
            desc = "CLP Holdings Ltd.";
        } else if (id.equalsIgnoreCase("CMH")) {
            desc = "China Merchants Holdings (Int'l)Co.Ltd.";
        } else if (id.equalsIgnoreCase("CNC")) {
            desc = "CNOOC Ltd";
        } else if (id.equalsIgnoreCase("COS")) {
            desc = "cosco Pacific Limited";
        } else if (id.equalsIgnoreCase("CPA")) {
            desc = "Cathay Pacific Airways Ltd";
        } else if (id.equalsIgnoreCase("CRE")) {
            desc = "China Resources Enterprise Ltd.";
        } else if (id.equalsIgnoreCase("HEH")) {
            desc = "Hongkong Electric Holdings Ltd.";
        } else if (id.equalsIgnoreCase("HEX")) {
            desc = "Hong Kong Exchanges and Clearing Ltd.";
        } else if (id.equalsIgnoreCase("HKB")) {
            desc = "HSBC Holdings Plc.";
        } else if (id.equalsIgnoreCase("HKG")) {
            desc = "Hong Kong & China Gas Co.Ltd., The";
        } else if (id.equalsIgnoreCase("HLD")) {
            desc = "Henderson Land Development Co. Ltd.";
        } else if (id.equalsIgnoreCase("HNP")) {
            desc = "Huaneng Power International, Inc.";
        } else if (id.equalsIgnoreCase("HSB")) {
            desc = "Hang Seng Bank Ltd.";
        } else if (id.equalsIgnoreCase("HWL")) {
            desc = "Hutchison Whampoa Ltd.";
        } else if (id.equalsIgnoreCase("JSE")) {
            desc = "Johnso Electric Holdings Ltd.";
        } else if (id.equalsIgnoreCase("LEH")) {
            desc = "Legend Group Ltd.";
        } else if (id.equalsIgnoreCase("LIF")) {
            desc = "Li & Fung Ltd.";
        } else if (id.equalsIgnoreCase("MTR")) {
            desc = "MTR Corporation Ltd.";
        } else if (id.equalsIgnoreCase("NWD")) {
            desc = "New World Development Co., Ltd.";
        } else if (id.equalsIgnoreCase("PCC")) {
            desc = "PCCW Ltd.";
        } else if (id.equalsIgnoreCase("PEC")) {
            desc = "PetroChina Company Ltd.";
        } else if (id.equalsIgnoreCase("SHK")) {
            desc = "Sun Hung Kai Properties Ltd.";
        } else if (id.equalsIgnoreCase("SIH")) {
            desc = "Shanghai Industrial Holdings Ltd.";
        } else if (id.equalsIgnoreCase("SWA")) {
            desc = "Swire Pacific Ltd. \"A\"";
        } else if (id.equalsIgnoreCase("WHL")) {
            desc = "Wharf(Holdings)Ltd., The";
        }
        return desc;
    }

    public String mapChiFutures(String t2) {
        if (t2.equals("HSI")) {
            return "\u6046\u6307";
        }
        if (t2.equals("MHI")) {
            return "\u5c0f\u578b\u6046\u6307";
        }
        if (t2.equals("HHI")) {
            return "\u570b\u6307";
        }
        if (t2.equals("MCH")) {
            return "\u5c0f\u578b\u570b\u6307";
        }
        return t2;
    }

    public String mapChiMonth(String m2) {
        if (m2.equals("Jan")) {
            return "1\u6708";
        }
        if (m2.equals("Feb")) {
            return "2\u6708";
        }
        if (m2.equals("Mar")) {
            return "3\u6708";
        }
        if (m2.equals("Apr")) {
            return "4\u6708";
        }
        if (m2.equals("May")) {
            return "5\u6708";
        }
        if (m2.equals("Jun")) {
            return "6\u6708";
        }
        if (m2.equals("Jul")) {
            return "7\u6708";
        }
        if (m2.equals("Aug")) {
            return "8\u6708";
        }
        if (m2.equals("Sep")) {
            return "9\u6708";
        }
        if (m2.equals("Oct")) {
            return "10\u6708";
        }
        if (m2.equals("Nov")) {
            return "11\u6708";
        }
        if (m2.equals("Dec")) {
            return "12\u6708";
        }
        return m2;
    }

    public String mapChinese(String n2, int c2) {
        if (n2.equals("MHI")) {
            return "\u5c0f\u578b\u6046\u6307";
        }
        if (n2.equals("HSI") || n2.equals("HANG SENG INDEX")) {
            return "\u6046\u6307";
        }
        if (n2.equals("HHI")) {
            return "\u570b\u6307";
        }
        if (n2.equals("MCH")) {
            return "\u5c0f\u578b\u570b\u6307";
        }
        if (n2.equals("MHI1")) {
            return "\u5c0f\u578b\u6046\u6307\u8f49\u5009L1";
        }
        if (n2.equals("MHI2")) {
            return "\u5c0f\u578b\u6046\u6307\u8f49\u5009L2";
        }
        if (n2.equals("MHI3")) {
            return "\u5c0f\u578b\u6046\u6307\u8f49\u5009L3";
        }
        if (n2.equals("MHIC")) {
            return "\u5c0f\u578b\u6046\u6307\u8a8d\u8cfc\u671f\u6b0a";
        }
        if (n2.equals("MHIP")) {
            return "\u5c0f\u578b\u6046\u6307\u8a8d\u6cbd\u671f\u6b0a";
        }
        if (n2.equals("MHIF")) {
            return "\u5c0f\u578b\u6046\u6307\u671f\u8ca8";
        }
        if (n2.equals("HSI1")) {
            return "\u6046\u6307\u8f49\u5009L1";
        }
        if (n2.equals("HSI2")) {
            return "\u6046\u6307\u8f49\u5009L2";
        }
        if (n2.equals("HSI3")) {
            return "\u6046\u6307\u8f49\u5009L3";
        }
        if (n2.equals("HSIC")) {
            return "\u6046\u6307\u8a8d\u8cfc\u671f\u6b0a";
        }
        if (n2.equals("HSIP")) {
            return "\u6046\u6307\u8a8d\u6cbd\u671f\u6b0a";
        }
        if (n2.equals("HSIF")) {
            return "\u6046\u6307\u671f\u8ca8";
        }
        if (n2.equals("HHI1") && c2 == 4001) {
            return "\u570b\u6307\u8f49\u5009L1";
        }
        if (n2.equals("HHI2") && c2 == 4001) {
            return "\u570b\u6307\u8f49\u5009L2";
        }
        if (n2.equals("HHI3") && c2 == 4001) {
            return "\u570b\u6307\u8f49\u5009L3";
        }
        if (n2.equals("HHIC") && c2 == 4001) {
            return "\u570b\u6307\u8a8d\u8cfc\u671f\u6b0a";
        }
        if (n2.equals("HHIP") && c2 == 4001) {
            return "\u570b\u6307\u8a8d\u6cbd\u671f\u6b0a";
        }
        if (n2.equals("HHIF") && c2 == 4001) {
            return "\u570b\u6307\u671f\u8ca8";
        }
        if (n2.equals("HHI1") && c2 == 4008) {
            return "\u5c0f\u578b\u570b\u6307\u8f49\u5009L1";
        }
        if (n2.equals("HHI2") && c2 == 4008) {
            return "\u5c0f\u578b\u570b\u6307\u8f49\u5009L2";
        }
        if (n2.equals("HHI3") && c2 == 4008) {
            return "\u5c0f\u578b\u570b\u6307\u8f49\u5009L3";
        }
        if (n2.equals("HHIC") && c2 == 4008) {
            return "\u5c0f\u578b\u570b\u6307\u8a8d\u8cfc\u671f\u6b0a";
        }
        if (n2.equals("HHIP") && c2 == 4008) {
            return "\u5c0f\u578b\u570b\u6307\u8a8d\u6cbd\u671f\u6b0a";
        }
        if (n2.equals("HHIF") && c2 == 4008) {
            return "\u5c0f\u578b\u570b\u6307\u671f\u8ca8";
        }
        return n2;
    }

    public HashSet getActiveMarket() {
        HashSet<String> mktSet = new HashSet<String>();
        try {
            for (int i2 = 0; i2 < this.activeMkt.length; ++i2) {
                mktSet.add(this.activeMkt[i2]);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return mktSet;
    }

    public HashSet getProductList() {
        HashSet<String> set = new HashSet<String>();
        try {
            for (int i2 = 0; i2 < this.productList.length; ++i2) {
                set.add(this.productList[i2]);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return set;
    }

    public HashSet getNoProductClt() {
        HashSet<String> set = new HashSet<String>();
        try {
            for (int i2 = 0; i2 < this.noProductClt.length; ++i2) {
                set.add(this.noProductClt[i2]);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return set;
    }

    public String formatSeries(String s2) {
        String temp = "";
        temp = s2.indexOf(47) == -1 ? (s2.length() > 5 ? s2.substring(0, 3) + "O" + s2.substring(s2.length() - 1) + s2.substring(s2.length() - 2, s2.length() - 1) + s2.substring(3, s2.length() - 2) : s2.substring(0, 3) + "F" + s2.substring(s2.length() - 1) + s2.substring(s2.length() - 2, s2.length() - 1)) : s2;
        return temp;
    }
}

