/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.future.pricedepth.interactor;

import ilog.views.chart.IlvChartDataPicker;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDefaultChartDataPicker;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.event.ChartInteractionEvent;
import ilog.views.chart.graphic.IlvDataIndicator;
import ilog.views.chart.interactor.IlvChartDataInteractor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;

public class DoubleClickDataPickInteractor
extends IlvChartDataInteractor {
    private static final IlvDataInterval EMTPYRANGE = new IlvDataInterval(0.0, 0.0);
    private final IlvDataIndicator indic = new IlvDataIndicator(-1, EMTPYRANGE, null);
    private IlvDisplayPoint lastPoint = null;

    public DoubleClickDataPickInteractor() {
        super(0, 0);
        this.enableEvents(16L);
    }

    public IlvDataIndicator getIlvDataIndicator() {
        return this.indic;
    }

    @Override
    public void processMouseMotionEvent(MouseEvent evt) {
        IlvDisplayPoint ilvdisplaypoint = this.pickData(this.createDataPicker(evt));
        if (this.lastPoint != ilvdisplaypoint) {
            if (ilvdisplaypoint == null) {
                this.indic.setRange(EMTPYRANGE);
            } else {
                double d2 = ilvdisplaypoint.getXData();
                if (this.lastPoint == null || this.lastPoint.getXData() != d2) {
                    this.indic.setRange(new IlvDataInterval(d2 - 0.5, d2 + 0.5));
                }
            }
            this.lastPoint = ilvdisplaypoint;
        }
        super.processMouseMotionEvent(evt);
    }

    @Override
    public void processMouseEvent(MouseEvent evt) {
        IlvDisplayPoint ilvdisplaypoint;
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && evt.getID() == 500 && (ilvdisplaypoint = this.pickData(this.createDataPicker(evt))) != null) {
            this.fireChartInteractionEvent(new ChartInteractionEvent(this, ilvdisplaypoint));
        }
        super.processMouseEvent(evt);
    }

    @Override
    protected IlvChartDataPicker createDataPicker(MouseEvent evt) {
        return new IlvDefaultChartDataPicker(evt.getX(), evt.getY(), Integer.MAX_VALUE){

            @Override
            public double computeDistance(double x1, double y1, double x2, double y2) {
                return Math.abs(x1 - x2);
            }

            @Override
            public boolean accept(IlvChartRenderer renderer) {
                int c2 = renderer.getDataSource().getDataSetCount();
                if (c2 > 1) {
                    return renderer.getNearestPoint(this) != null;
                }
                if (c2 == 1) {
                    IlvDataSet ds = renderer.getDataSource().getDataSet(0);
                    Rectangle fullR = renderer.getPlotRect();
                    int y = fullR.y + fullR.height - 1;
                    Rectangle2D r2 = renderer.getBounds(ds, 0, ds.getDataCount() - 1, fullR);
                    return r2.contains(this.getPickX(), y);
                }
                return false;
            }
        };
    }
}

